
import React, { useState } from 'react';
import { useToast } from '../../context/ToastContext';

export const GrowthChart: React.FC = () => {
  const [weight, setWeight] = useState('');
  const [height, setHeight] = useState('');
  const [age, setAge] = useState('');
  const { addToast } = useToast();

  const handleAddPoint = () => {
      if (weight && height && age) {
          addToast('تمت إضافة نقطة قياس جديدة للمخطط', 'success');
          // In a real app, this would update chart data
          setWeight('');
          setHeight('');
          setAge('');
      } else {
          addToast('يرجى تعبئة جميع الحقول', 'error');
      }
  };

  return (
    <div className="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
      <div className="flex justify-between items-center mb-6 border-b border-gray-100 pb-4">
        <h3 className="text-lg font-bold text-gray-800 flex items-center gap-2">
            <i className="fas fa-chart-line text-orange-500"></i>
            مخطط النمو (WHO Growth Standards)
        </h3>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
          <div>
              <label className="block text-sm font-medium text-gray-700 mb-1">العمر (أشهر)</label>
              <input 
                type="number" 
                value={age} 
                onChange={e => setAge(e.target.value)} 
                className="w-full px-3 py-2 border rounded-lg bg-white text-gray-900" 
              />
          </div>
          <div>
              <label className="block text-sm font-medium text-gray-700 mb-1">الوزن (kg)</label>
              <input 
                type="number" 
                value={weight} 
                onChange={e => setWeight(e.target.value)} 
                className="w-full px-3 py-2 border rounded-lg bg-white text-gray-900" 
              />
          </div>
          <div>
              <label className="block text-sm font-medium text-gray-700 mb-1">الطول (cm)</label>
              <input 
                type="number" 
                value={height} 
                onChange={e => setHeight(e.target.value)} 
                className="w-full px-3 py-2 border rounded-lg bg-white text-gray-900" 
              />
          </div>
      </div>
      <button onClick={handleAddPoint} className="w-full bg-orange-100 text-orange-700 font-bold py-2 rounded-lg hover:bg-orange-200 transition-colors mb-6">
          + إضافة قياس
      </button>

      {/* Mock Chart Area */}
      <div className="relative h-64 w-full bg-gray-50 rounded-xl border border-gray-200 p-4 flex items-end justify-between overflow-hidden">
          {/* Grid Lines */}
          <div className="absolute inset-0 grid grid-cols-6 grid-rows-4 pointer-events-none">
              {[...Array(24)].map((_, i) => <div key={i} className="border-r border-t border-gray-200/50"></div>)}
          </div>
          
          {/* Mock Lines */}
          <svg className="absolute inset-0 w-full h-full pointer-events-none opacity-50" viewBox="0 0 100 100" preserveAspectRatio="none">
              {/* Average Line */}
              <path d="M0,90 Q50,50 100,10" stroke="#22c55e" strokeWidth="2" fill="none" strokeDasharray="5,5" />
              {/* Upper Bound */}
              <path d="M0,80 Q50,40 100,0" stroke="#eab308" strokeWidth="1" fill="none" />
              {/* Lower Bound */}
              <path d="M0,95 Q50,70 100,30" stroke="#eab308" strokeWidth="1" fill="none" />
          </svg>

          {/* Sample Points */}
          <div className="absolute left-[10%] bottom-[20%] w-3 h-3 bg-blue-500 rounded-full border-2 border-white shadow-sm z-10" title="شهر 2"></div>
          <div className="absolute left-[30%] bottom-[45%] w-3 h-3 bg-blue-500 rounded-full border-2 border-white shadow-sm z-10" title="شهر 6"></div>
          <div className="absolute left-[50%] bottom-[60%] w-3 h-3 bg-blue-500 rounded-full border-2 border-white shadow-sm z-10" title="شهر 12"></div>
      </div>
      <div className="flex justify-between text-xs text-gray-400 mt-2">
          <span>الولادة</span>
          <span>6 أشهر</span>
          <span>سنة</span>
          <span>سنتين</span>
      </div>
    </div>
  );
};
