
import { Tenant, Patient, SubscriptionStatus, Appointment, Invoice, Plan, Visit, Service, Template, LabOrder, BirthRecord, ModuleFeature, CustomForm, DynamicPage, InventoryItem, Prescription, ClinicStaff, MedicalReport, AuditLog, SupportTicket } from './types';

export const mockTenants: Tenant[] = [
  {
    id: '1',
    name: 'د. أحمد خالد',
    email: 'ahmed@clinic.com',
    phone: '0912345678',
    clinicName: 'عيادة الشفاء',
    clinicType: 'general',
    plan: 'yearly',
    status: SubscriptionStatus.ACTIVE,
    expiryDate: '2025-05-20',
    domain: 'ahmed.clinicpro.com',
    template: 'medical-blue',
    activationCode: 'PRO-2024',
    isActivated: false,
    syncStatus: 'online'
  },
  {
    id: '2',
    name: 'د. سارة محمد',
    email: 'sara@clinic.com',
    phone: '0987654321',
    clinicName: 'مركز الحياة',
    clinicType: 'obgyn',
    plan: 'monthly',
    status: SubscriptionStatus.EXPIRED,
    expiryDate: '2024-05-10',
    domain: 'sara-center.com',
    template: 'modern-green',
    activationCode: 'SARA-123',
    isActivated: true,
    syncStatus: 'offline'
  },
  {
    id: '3',
    name: 'د. البيطري سعيد',
    email: 'vet@clinic.com',
    phone: '099999999',
    clinicName: 'عيادة الحيوانات الأليفة',
    clinicType: 'vet',
    plan: 'yearly',
    status: SubscriptionStatus.ACTIVE,
    expiryDate: '2025-01-01',
    domain: 'vet.clinicpro.com',
    template: 'modern-green',
    activationCode: 'VET-2024',
    isActivated: true,
    syncStatus: 'online'
  }
];

export const mockPatients: Patient[] = [
  { id: '101', name: 'منى علي', age: 28, phone: '0933333333', diagnosis: 'متابعة حمل', lastVisit: '2024-05-20', status: 'pregnant', customData: { edd: '2024-11-15' } },
  { id: '102', name: 'فاطمة حسن', age: 45, phone: '0944444444', diagnosis: 'سكري', lastVisit: '2024-05-18', status: 'regular' },
  { id: '103', name: 'ليلى أحمد', age: 32, phone: '0955555555', diagnosis: 'ضغط دم', lastVisit: '2024-05-15', status: 'critical' },
];

export const mockAppointments: Appointment[] = [
  { id: '1', patientName: 'منى علي', date: '2024-05-22', time: '10:00', type: 'كشف دوري', status: 'confirmed' },
  { id: '2', patientName: 'خالد عمر', date: '2024-05-22', time: '10:30', type: 'استشارة', status: 'pending' },
  { id: '3', patientName: 'فاطمة حسن', date: '2024-05-22', time: '11:00', type: 'متابعة', status: 'completed' },
  { id: '4', patientName: 'سعيد محمد', date: '2024-05-23', time: '09:00', type: 'جراحة صغرى', status: 'confirmed' },
];

export const mockInvoices: Invoice[] = [
  { id: 'INV-001', patientName: 'منى علي', date: '2024-05-20', amount: 150, status: 'paid', service: 'كشف حمل' },
  { id: 'INV-002', patientName: 'فاطمة حسن', date: '2024-05-18', amount: 300, status: 'pending', service: 'تحاليل شاملة' },
  { id: 'INV-003', patientName: 'ليلى أحمد', date: '2024-05-15', amount: 100, status: 'paid', service: 'استشارة' },
  { id: 'INV-004', patientName: 'خالد عمر', date: '2024-05-12', amount: 50, status: 'overdue', service: 'ضماد' },
];

export const mockPlans: Plan[] = [
  {
    id: 'p1',
    name: 'الباقة الأساسية',
    price: 30,
    period: 'monthly',
    features: ['إدارة المرضى', 'المواعيد', 'دعم فني عبر البريد', 'نسخ احتياطي يومي'],
  },
  {
    id: 'p2',
    name: 'الباقة المتقدمة',
    price: 300,
    period: 'yearly',
    features: ['كل مميزات الأساسية', 'إدارة المخزون', 'دعم فني واتساب', 'دومين مجاني', 'تقارير متقدمة'],
    isPopular: true
  },
  {
    id: 'p3',
    name: 'باقة العيادات',
    price: 500,
    period: 'yearly',
    features: ['تعدد الأطباء', 'شاشة انتظار', 'API ربط خارجي', 'مدير حساب خاص'],
  }
];

export const mockVisits: Visit[] = [
    { id: 'v1', patientId: '101', date: '2024-05-20', type: 'كشف دوري', cost: 150, paid: 150, notes: 'ضغط الدم طبيعي، نبض الجنين سليم.' },
    { id: 'v2', patientId: '101', date: '2024-04-20', type: 'كشف أول', cost: 200, paid: 200, notes: 'تأكيد الحمل، صرف فيتامينات.' },
    { id: 'v3', patientId: '102', date: '2024-05-18', type: 'متابعة سكر', cost: 100, paid: 100, notes: 'السكر التراكمي مرتفع قليلاً. تعديل الجرعة.' },
];

export const mockServices: Service[] = [
    { id: 's1', name: 'كشف عام', price: 30, description: 'فحص سريري شامل' },
    { id: 's2', name: 'تنظيف أسنان', price: 50, description: 'إزالة الجير والتلميع' },
    { id: 's3', name: 'حشوة تجميلية', price: 80 },
    { id: 's4', name: 'سحب عصب', price: 150, description: 'جلسة واحدة مع تخدير' },
];

export const mockTemplates: Template[] = [
    { id: 't1', name: 'الطبي الأزرق (Standard)', thumbnail: 'https://placehold.co/600x400/007bff/ffffff?text=Blue+Medical', category: 'طب عام', isActive: true },
    { id: 't2', name: 'الأسنان الحديث (Dental)', thumbnail: 'https://placehold.co/600x400/28a745/ffffff?text=Dental+Bright', category: 'أسنان', isActive: true },
    { id: 't3', name: 'الوردي اللطيف (OB/GYN)', thumbnail: 'https://placehold.co/600x400/e83e8c/ffffff?text=Pink+Care', category: 'نسائية', isActive: true },
    { id: 't4', name: 'الأطفال المرح (Kids)', thumbnail: 'https://placehold.co/600x400/ffc107/000000?text=Kids+Clinic', category: 'أطفال', isActive: false },
    { id: 't5', name: 'الجلدية والتجميل', thumbnail: 'https://placehold.co/600x400/6f42c1/ffffff?text=Derma+Beauty', category: 'تجميل', isActive: true },
    { id: 't6', name: 'الأخضر الحديث (Modern)', thumbnail: 'https://placehold.co/600x400/20c997/ffffff?text=Modern+Green', category: 'طب عام', isActive: true },
    { id: 't7', name: 'العيون الاحترافي (Ophth)', thumbnail: 'https://placehold.co/600x400/4f46e5/ffffff?text=Eye+Vision', category: 'عيون', isActive: true },
    { id: 't8', name: 'البيطري الودود (Vet)', thumbnail: 'https://placehold.co/600x400/d97706/ffffff?text=Happy+Vet', category: 'بيطري', isActive: true },
    { id: 't9', name: 'العظام والمفاصل (Ortho)', thumbnail: 'https://placehold.co/600x400/57534e/ffffff?text=Ortho+Care', category: 'عظام', isActive: true },
    { id: 't10', name: 'طبيب العائلة (Family)', thumbnail: 'https://placehold.co/600x400/0891b2/ffffff?text=Family+Doc', category: 'طب عام', isActive: true },
    // New Templates
    { id: 't11', name: 'التغذية والدايت (Nutrition)', thumbnail: 'https://placehold.co/600x400/84cc16/ffffff?text=Nutri+Fit', category: 'تغذية', isActive: true },
    { id: 't12', name: 'العلاج الطبيعي (Physio)', thumbnail: 'https://placehold.co/600x400/06b6d4/ffffff?text=Physio+Flex', category: 'علاج طبيعي', isActive: true },
    { id: 't13', name: 'الطب النفسي (Psych)', thumbnail: 'https://placehold.co/600x400/8b5cf6/ffffff?text=Mind+Peace', category: 'نفسية', isActive: true },
    { id: 't14', name: 'القلب والأوعية (Cardio)', thumbnail: 'https://placehold.co/600x400/ef4444/ffffff?text=Heart+Beat', category: 'قلبية', isActive: true },
    { id: 't15', name: 'الأعصاب (Neuro)', thumbnail: 'https://placehold.co/600x400/334155/ffffff?text=Brain+Neuro', category: 'أعصاب', isActive: true },
];

export const mockLabOrders: LabOrder[] = [
  { id: 'L-101', patientName: 'سعيد محمد', item: 'Zirconia Crown', labName: 'معمل الابتسامة', sentDate: '2024-05-20', deliveryDate: '2024-05-25', status: 'sent', shade: 'A2' },
  { id: 'L-102', patientName: 'منى علي', item: 'Night Guard', labName: 'معمل النخبة', sentDate: '2024-05-18', deliveryDate: '2024-05-22', status: 'received', shade: 'N/A' },
];

export const mockBirthRecords: BirthRecord[] = [
  { id: 'B-01', motherName: 'منى علي', babyName: 'زين', date: '2023-11-15', time: '14:30', gender: 'male', weight: 3.2, deliveryType: 'natural', notes: 'ولادة طبيعية ميسرة' },
  { id: 'B-02', motherName: 'سارة أحمد', babyName: 'ليان', date: '2024-01-20', time: '08:15', gender: 'female', weight: 2.9, deliveryType: 'c-section', notes: 'عملية قيصرية مجدولة' },
];

// --- NO-CODE MOCK DATA ---

export const mockModules: ModuleFeature[] = [
  { id: 'm1', key: 'patients', defaultName: 'سجل المرضى', description: 'إدارة ملفات المرضى الأساسية', isEnabled: true, icon: 'fa-users', clinicTypes: ['general', 'dental', 'obgyn', 'vet', 'ophthalmology', 'orthopedics'] },
  { id: 'm2', key: 'appointments', defaultName: 'المواعيد', description: 'جدول المواعيد والزيارات', isEnabled: true, icon: 'fa-calendar-alt', clinicTypes: ['general', 'dental', 'obgyn', 'vet', 'ophthalmology', 'orthopedics'] },
  { id: 'm3', key: 'dental_chart', defaultName: 'مخطط الأسنان', description: 'رسم تفاعلي للأسنان', isEnabled: true, icon: 'fa-tooth', clinicTypes: ['dental'] },
  { id: 'm4', key: 'pregnancy', defaultName: 'متابعة الحمل', description: 'حساب الحمل والولادة', isEnabled: true, icon: 'fa-baby', clinicTypes: ['obgyn', 'obstetrics'] },
  { id: 'm5', key: 'lab', defaultName: 'المعمل', description: 'تتبع الطلبات الخارجية', isEnabled: true, icon: 'fa-flask', clinicTypes: ['dental', 'general'] },
];

export const mockCustomForms: CustomForm[] = [
  {
    id: 'form_vet_1',
    title: 'سجل حيوان أليف (Pet Profile)',
    description: 'نموذج تسجيل بيانات الحيوان للعيادات البيطرية',
    clinicType: 'vet',
    isSystem: false,
    createdAt: '2024-05-01',
    fields: [
      { id: 'f1', type: 'text', label: 'اسم الحيوان', required: true, placeholder: 'مثال: سيمبا', width: 'half' },
      { id: 'f2', type: 'select', label: 'النوع (Species)', required: true, options: ['قط', 'كلب', 'طائر', 'آخر'], width: 'half' },
      { id: 'f3', type: 'text', label: 'الفصيلة (Breed)', required: false, width: 'half' },
      { id: 'f4', type: 'number', label: 'العمر (بالسنوات)', required: false, width: 'half' },
      { id: 'f5', type: 'text', label: 'رقم الشريحة (Microchip)', required: false, width: 'full' },
      { id: 'f6', type: 'date', label: 'تاريخ آخر تطعيم', required: false, width: 'full' },
    ]
  },
  {
    id: 'form_eye_1',
    title: 'فحص البصر (Vision Test)',
    description: 'نموذج قياس حدة البصر',
    clinicType: 'ophthalmology',
    isSystem: false,
    createdAt: '2024-05-05',
    fields: [
      { id: 'e1', type: 'text', label: 'حدة البصر (العين اليمنى)', required: true, placeholder: '6/6', width: 'half' },
      { id: 'e2', type: 'text', label: 'حدة البصر (العين اليسرى)', required: true, placeholder: '6/6', width: 'half' },
      { id: 'e3', type: 'checkbox', label: 'هل يوجد عمى ألوان؟', required: false, width: 'full' },
      { id: 'e4', type: 'textarea', label: 'ملاحظات الطبيب', required: false, width: 'full' },
    ]
  }
];

export const mockDynamicPages: DynamicPage[] = [
  { id: 'p1', title: 'سجل الحيوانات', path: 'vet-records', icon: 'fa-paw', type: 'form', connectedFormId: 'form_vet_1', clinicType: 'vet', order: 1, isVisible: true },
  { id: 'p2', title: 'فحص البصر', path: 'vision-test', icon: 'fa-eye', type: 'form', connectedFormId: 'form_eye_1', clinicType: 'ophthalmology', order: 1, isVisible: true },
];

export const mockInventory: InventoryItem[] = [
  { id: 'inv1', name: 'Panadol Extra', quantity: 50, unit: 'علبة', minThreshold: 10, category: 'medicine', expiryDate: '2025-10-01' },
  { id: 'inv2', name: 'قفازات طبية', quantity: 5, unit: 'صندوق', minThreshold: 10, category: 'consumable' },
  { id: 'inv3', name: 'حشوة كومبوزيت', quantity: 2, unit: 'حقنة', minThreshold: 5, category: 'equipment', expiryDate: '2024-12-01' },
];

export const mockPrescriptions: Prescription[] = [
  { 
    id: 'rx1', 
    patientId: '101', 
    patientName: 'منى علي', 
    date: '2024-05-20', 
    doctorName: 'د. أحمد خالد',
    items: [
      { drugName: 'Folic Acid', dosage: '5mg', frequency: 'مرة يومياً', duration: '3 أشهر', notes: 'بعد الغداء' }
    ] 
  }
];

export const mockStaff: ClinicStaff[] = [
  { id: 's1', name: 'د. أحمد خالد', role: 'doctor', email: 'ahmed@clinic.com', phone: '0912345678', status: 'active', permissions: ['all'] },
  { id: 's2', name: 'مروة حسن', role: 'receptionist', email: 'marwa@clinic.com', phone: '0988776655', status: 'active', permissions: ['patients_view', 'appointments_manage'] },
  { id: 's3', name: 'سالم علي', role: 'nurse', email: 'salem@clinic.com', phone: '0911223344', status: 'inactive', permissions: ['patients_view'] },
];

export const mockMedicalReports: MedicalReport[] = [
  { id: 'R-001', patientName: 'خالد عمر', type: 'sick_leave', date: '2024-05-22', doctorName: 'د. أحمد خالد', content: 'يمنح المريض إجازة مرضية لمدة يومين بسبب نزلة برد حادة.' },
];

export const mockAuditLogs: AuditLog[] = [
  { id: 'log1', action: 'LOGIN', user: 'ahmed@clinic.com', role: 'DOCTOR', details: 'تسجيل دخول ناجح', timestamp: '2024-05-22 09:00:00', ip: '192.168.1.1' },
  { id: 'log2', action: 'UPDATE_PATIENT', user: 'ahmed@clinic.com', role: 'DOCTOR', details: 'تحديث ملف المريض: منى علي', timestamp: '2024-05-22 10:15:00', ip: '192.168.1.1' },
  { id: 'log3', action: 'CREATE_TENANT', user: 'admin@clinicpro.com', role: 'SUPER_ADMIN', details: 'إنشاء عيادة جديدة: د. البيطري سعيد', timestamp: '2024-05-21 14:30:00', ip: '10.0.0.5' },
  { id: 'log4', action: 'DELETE_APPOINTMENT', user: 'sara@clinic.com', role: 'DOCTOR', details: 'حذف موعد رقم #45', timestamp: '2024-05-21 11:20:00', ip: '192.168.1.15' },
  { id: 'log5', action: 'SYSTEM_BACKUP', user: 'SYSTEM', role: 'SYSTEM', details: 'نسخ احتياطي تلقائي', timestamp: '2024-05-22 00:00:00', ip: 'localhost' },
];

export const mockSupportTickets: SupportTicket[] = [
  { id: 't1', tenantId: '1', tenantName: 'عيادة الشفاء', subject: 'مشكلة في طباعة الفواتير', message: 'الفواتير تظهر بدون شعار العيادة عند الطباعة', status: 'open', priority: 'medium', createdAt: '2024-05-22', lastUpdate: '2024-05-22' },
  { id: 't2', tenantId: '2', tenantName: 'مركز الحياة', subject: 'طلب زيادة عدد المستخدمين', message: 'نحتاج لإضافة ممرضة جديدة والنظام يرفض', status: 'in_progress', priority: 'high', createdAt: '2024-05-21', lastUpdate: '2024-05-22' },
  { id: 't3', tenantId: '1', tenantName: 'عيادة الشفاء', subject: 'استفسار عن الدفع', message: 'هل يمكن الدفع عبر PayPal؟', status: 'resolved', priority: 'low', createdAt: '2024-05-20', lastUpdate: '2024-05-21' },
];
