
const CACHE_NAME = 'khaled-qasreen-system-v3';
const STATIC_ASSETS = [
  '/',
  '/index.html',
  // Add common CDNs to improve speed and offline capability
  'https://cdn.tailwindcss.com',
  'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css',
  'https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap'
];

self.addEventListener('install', (event) => {
  event.waitUntil(
    caches.open(CACHE_NAME).then((cache) => {
      console.log('Opened cache');
      return cache.addAll(STATIC_ASSETS);
    })
  );
  self.skipWaiting();
});

self.addEventListener('activate', (event) => {
  event.waitUntil(
    caches.keys().then((cacheNames) => {
      return Promise.all(
        cacheNames.map((cacheName) => {
          if (cacheName !== CACHE_NAME) {
            console.log('Deleting old cache:', cacheName);
            return caches.delete(cacheName);
          }
        })
      );
    })
  );
  self.clients.claim();
});

self.addEventListener('fetch', (event) => {
  // Strategy: Cache First for static assets, Network First for everything else
  // This provides a faster UI load while keeping data fresh-ish
  const isStatic = STATIC_ASSETS.some(url => event.request.url.includes(url));

  if (isStatic) {
      event.respondWith(
        caches.match(event.request).then((response) => {
          return response || fetch(event.request).then((networkResponse) => {
             return caches.open(CACHE_NAME).then((cache) => {
                 cache.put(event.request, networkResponse.clone());
                 return networkResponse;
             });
          });
        })
      );
  } else {
      event.respondWith(
        fetch(event.request)
          .then((response) => {
            // Check for valid response
            if (!response || response.status !== 200 || response.type !== 'basic') {
              return response;
            }
            // Clone and cache successful GET requests
            if(event.request.method === 'GET') {
                const responseToCache = response.clone();
                caches.open(CACHE_NAME).then((cache) => {
                  cache.put(event.request, responseToCache);
                });
            }
            return response;
          })
          .catch(() => {
            // If offline, try to serve from cache
            return caches.match(event.request);
          })
      );
  }
});
